nginx-packages:
  pkg.installed:
    - pkgs:
      - nginx-core
      - nginx-common

nginx-ssl-dir:
  file.directory:
    - name: /etc/nginx/ssl
    - user: root
    - group: root
    - dir_mode: 755
    - require:
      - pkg: nginx-packages

nginx-dhparam-file:
  cmd.run:
    - require:
      - file: nginx-ssl-dir
    - name: openssl dhparam -out /etc/nginx/ssl/dhparam.pem 2048
    - unless: ls -al /etc/nginx/ssl/dhparam.pem

nginx-ssl-cert-file:
  file.managed:
    - makedirs: True
    - name: /etc/nginx/ssl/cert.pem
    - user: root
    - group: root
    - mode: 400
    - contents: {{ pillar['server-certificate']['cert'] | json }}
    - require:
      - file: nginx-ssl-dir

nginx-ssl-key-file:
  file.managed:
    - makedirs: True
    - name: /etc/nginx/ssl/key.pem
    - user: root
    - group: root
    - mode: 400
    - contents: {{ pillar['server-certificate']['key'] | json }}
    - require:
      - file: nginx-ssl-dir

nginx-default-config-disable:
  file.absent:
    - name: /etc/nginx/sites-enabled/default
    - require:
      - pkg: nginx-packages

nginx-dp-config:
  file.managed:
    - name: /etc/nginx/sites-enabled/dp.conf
    - require:
      - pkg: nginx-packages
    - contents: |
        server {
            listen 80;
            listen [::]:80;
            server_name {{ salt['grains.get']('fqdn') }};
            location / {
                return 301 https://$host$request_uri;
            }
        }
        
        server {
            listen                          443 ssl http2;
            listen                          [::]:443 ssl http2;
            server_name                     {{ salt['grains.get']('fqdn') }};
            ssl_certificate                 /etc/nginx/ssl/cert.pem;
            ssl_certificate_key             /etc/nginx/ssl/key.pem;
            ssl_dhparam                     /etc/nginx/ssl/dhparam.pem;
            ssl_prefer_server_ciphers       on;
            ssl_protocols                   TLSv1 TLSv1.1 TLSv1.2 TLSv1.3;
            ssl_ciphers                     kEECDH+AESGCM+AES128:TLS-CHACHA20-POLY1305-SHA256:kEECDH+AES128:kRSA+AESGCM+AES128:kRSA+AES128:DES-CBC3-SHA:!RC4:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2;
            ssl_session_cache               shared:SSL:64m;
            ssl_session_timeout             28h;
            add_header Strict-Transport-Security "max-age=31536000; includeSubdomains; preload";
            root /var/storage/nginx;
            index index.html index.htm;
            
            location / {
                autoindex on;
            }
        }

nginx-service-running:
  service.running:
    - name: nginx
    - enable: True
    - reload: True
    - watch:
      - file: nginx-dp-config
    - require:
      - pkg: nginx-packages

