samba-packages:
  pkg.installed:
    - pkgs:
      - samba
      - winbind
      - smbclient

smbuser:
  user.present:
    - fullname: Samba Reader
    - shell: /usr/sbin/nologin
    - home: /home/smbuser
    - password: {{ pillar['smbuser']['password-hash'] }}

smbuser-pdb:
  pdbedit.managed:
    - name: smbuser
    - password: {{ pillar['smbuser']['password-hash-nt'] }}
    - password_hashed: True
    - require:
      - pkg: samba-packages
      - user: smbuser

samba-config:
  file.managed:
    - name: /etc/samba/smb.conf
    - require:
      - pkg: samba-packages
    - contents: |
        [global]
          workgroup = WORKGROUP

          server min protocol = SMB2_10
          server max protocol = SMB3_11
          client min protocol = SMB2_10
          client max protocol = SMB3_11
        
          case sensitive = no
          template shell = /sbin/nologin
          ntlm auth = No
          lanman auth = No
          unix password sync = yes
          domain master = no
          local master = no
          preferred master = no
          os level = 0
          domain logons = no
        
          server string = %h server (Samba, Ubuntu)
          dns proxy = no
        
          log level = 3
          log file = /var/log/samba/log.%m
          max log size = 1000
          panic action = /usr/share/samba/panic-action %d
        
          server role = standalone server
          map to guest = bad user
        
          load printers = no
          show add printer wizard = no
          printcap name = /dev/null
          disable spoolss = yes
        
        [ds$]
          browseable = yes
          path = /var/storage/ds
          guest ok = no
          read only = yes
          create mask = 0755
          directory mask = 0755
          read list = smbuser

samba-service-running:
  service.running:
    - name: smbd
    - enable: True
    - reload: True
    - watch:
      - file: samba-config
    - require:
      - pkg: samba-packages

winbind-service-running:
  service.running:
    - name: winbind
    - enable: True
    - require:
      - pkg: samba-packages

