#!/usr/bin/env bash

# Response function
die () {
    # $1: 0 - OK, 1 WARN, 2 CRIT
    # $2 message

    echo "PASSIVE-CHECK:servicedesck.telegram.last.excepton.service;$1;$2"

    exit 0
}

re='^[0-9]+$'

# Check log file
[[ -f $JUGGLER_CHECK_TELEGRAM_ERROR_LOG ]] || die 0 "OK"

# Check argument
[[ -z $1 ]] && die 2 "Interval argument is empty"

# Check argument numbers
[[ $1 =~ $re ]] || die 2 "Interval argument is not number"

# Get diff
diff=$(( $(date +"%s") - $1 ))

# Search last exception
search=$(grep Timestamp $JUGGLER_CHECK_TELEGRAM_ERROR_LOG | tail -n 1 | awk '{print $2}')

# If not found - OK
[[ -z $search ]] && die 0 "OK"

# Check is numeric
[[ $search =~ $re ]] || die 2 "Last exception timestamp is not number"

# Check interval
[[ $search > $diff ]] && die 2 "New exception found"

die 0 "OK"