#!/usr/bin/env bash

job_name=$1

if [[ -z $job_name ]]; then
    echo "Arguments error"
    exit 1
fi

die() {
    # $1: 0 - OK, 1 WARN, 2 CRIT
    # $2 message

    echo "PASSIVE-CHECK:jobber.$job_name;$1;$2"
    exit 0
}

job_status_line=$(jobber list | grep "$job_name\s")

if [[ -z $job_status_line ]]; then
    echo "Job $job_name not found"
    exit 1
fi

check_status="Failed"

cnt_job_failed=$(echo $job_status_line | grep $check_status | wc -l)

if [[ $cnt_job_failed > 0 ]]; then
    die 2 $check_status
else
    die 0 "OK"
fi
