#!/usr/bin/env python3

import requests
import urllib3
import sys

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

def response(code, msg):
    '''Code: 0 - OK, 1 WARN, 2 CRIT'''

    print(f'PASSIVE-CHECK:{service};{code};{msg}')
    exit(0)

try:
    service = sys.argv[1]
    url = sys.argv[2]
except IndexError:
    response(2, 'Arguments error')

try:
    resp = requests.get(url=url, verify=False)
    resp.json()
except Exception:
    response(2, 'API response error')

response(0, 'OK')
