#!/bin/bash

service=$1
statusfile=$2

die() {
    # $1: 0 - OK, 1 WARN, 2 CRIT
    # $2 message

    echo "PASSIVE-CHECK:$service;$1;$2"

    exit 0
}

[[ -z $service ]] || [[ -z $statusfile ]] && die 2 "Argument is empty"
[[ -f $statusfile ]] || echo "SUCCESS" > $statusfile
[[ $(cat $statusfile) == "FAIL"* ]] && die 2 "Last status is FAIL"
[[ $(cat $statusfile) == "SUCCESS"* ]] && die 0 "OK"

die 2 "Status file error"
