package main

import (
	"a.yandex-team.ru/infra/alert_controller/cmd/controller"
	"a.yandex-team.ru/infra/alert_controller/cmd/export"
	"a.yandex-team.ru/infra/alert_controller/cmd/generate"
	"a.yandex-team.ru/infra/alert_controller/cmd/project"
	"a.yandex-team.ru/infra/alert_controller/cmd/stats"
	"fmt"
	"os"

	"github.com/spf13/cobra"
)

var (
	cfgFile string

	rootCmd = &cobra.Command{
		Use:   "alertctl",
		Short: "Manage deploy/nanny default alerts",
	}
)

func init() {
	rootCmd.PersistentFlags().StringVar(&cfgFile, "config", "", "")

	rootCmd.AddCommand(generate.Generate())
	rootCmd.AddCommand(controller.StartController())
	rootCmd.AddCommand(project.FillProjects())
	rootCmd.AddCommand(stats.CalcStatistics())
	rootCmd.AddCommand(export.StartSynchronizer())

}

func main() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Fprintln(os.Stderr, err)
		os.Exit(1)
	}
}
