package config

import (
	"a.yandex-team.ru/infra/alert_controller/internal/util"
	"fmt"
	"gopkg.in/yaml.v2"
	"io/ioutil"
)

func ReadConfig(path string) (config util.Config, err error) {
	data, err := ioutil.ReadFile(path)
	if err != nil {
		err = fmt.Errorf("failed to read config: %v", err)
		return
	}

	err = yaml.Unmarshal(data, &config)
	if err != nil {
		err = fmt.Errorf("failed to unmarshal config: %v", err)
		return
	}

	return
}
