package solomon

import "a.yandex-team.ru/infra/alert_controller/internal/swagger"

func LoadSavedTemplates() []TemplateInfo {
	var templates = make([]TemplateInfo, 0)
	templates = append(templates, TemplateInfo{
		ID:      "deploy-cpu-usage",
		Version: "multi-prod-1",
		Name:    "CPU usage",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-cpu-wait",
		Version: "multi-prod-1",
		Name:    "CPU wait",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-memory-usage",
		Version: "multi-prod-1",
		Name:    "Memory usage",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-ooms",
		Version: "multi-prod-1",
		Name:    "OOM",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-page-fault",
		Version: "multi-prod-1",
		Name:    "Page faults",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-core-dump",
		Version: "multi-prod-1",
		Name:    "Coredumps",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-main-disk-usage",
		Version: "multi-prod-1",
		Name:    "Main disk usage",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-disruption-budget-overcommit",
		Version: "prod-2",
		Name:    "Disruption budget overcommit",
	})
	return templates
}

func LoadExperimentalTemplates() []TemplateInfo {
	var templates = make([]TemplateInfo, 0)
	templates = append(templates, TemplateInfo{
		ID:      "deploy-cpu-usage",
		Version: "multi-prod-1",
		Name:    "CPU usage",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-cpu-wait",
		Version: "multi-prod-1",
		Name:    "CPU wait",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-memory-usage",
		Version: "multi-prod-1",
		Name:    "Memory usage",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-ooms",
		Version: "multi-prod-1",
		Name:    "OOM",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-page-fault",
		Version: "multi-prod-1",
		Name:    "Page faults",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-core-dump",
		Version: "multi-prod-1",
		Name:    "Coredumps",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-main-disk-usage",
		Version: "multi-prod-1",
		Name:    "Main disk usage",
	})
	templates = append(templates, TemplateInfo{
		ID:      "deploy-disruption-budget-overcommit",
		Version: "prod-2",
		Name:    "Disruption budget overcommit",
	})
	return templates
}

func ConvertFromMap(stub map[string]string) []TemplateInfo {
	var templates = make([]TemplateInfo, 0)
	for id, version := range stub {
		templates = append(templates, TemplateInfo{
			ID:      id,
			Version: version,
			Name:    id,
		})
	}
	return templates
}

func ConvertFromSolomonTemplates(solomonTemplates []swagger.AlertTemplate) []TemplateInfo {
	var templates = make([]TemplateInfo, 0)
	for _, tmpl := range solomonTemplates {
		templates = append(templates, TemplateInfo{
			ID:      tmpl.Id,
			Version: tmpl.TemplateVersionTag,
			Name:    tmpl.Name,
		})
	}
	return templates
}
