/*
 * Solomon API v2.0
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * API version: 2.0
 * Contact: solomon@yandex-team.ru
 * Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 */

package swagger

import (
	"a.yandex-team.ru/infra/alert_controller/internal/antihax/optional"
	"context"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"
)

// Linger please
var (
	_ context.Context
)

type SensorsApiService service

/*
SensorsApiService find all label values by selector query
This action returns values of label by selector query if user have permissions to read that project.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectId projectId
 * @param optional nil or *SensorsApiFindAllLabelValuesInOldFormatUsingGETOpts - Optional Parameters:
     * @param "ValidationFilter" (optional.String) -  label validation filter (internal parameter, will be removed)
     * @param "ForceCluster" (optional.String) -  force cluster parameter (dc abbreviation or empty)
     * @param "Limit" (optional.Int32) -  label values count limit [0; 100000]
     * @param "Names" (optional.Interface of []string) -  list of required label names joining by comma, leave it empty to show all label names
     * @param "Selectors" (optional.String) -  selector query
     * @param "Text" (optional.String) -  case insensitive text filter by labels
     * @param "UseNewFormat" (optional.Bool) -  use new selector query format

@return LabelValuesResponseDto
*/

type SensorsApiFindAllLabelValuesInOldFormatUsingGETOpts struct {
	ValidationFilter optional.String
	ForceCluster     optional.String
	Limit            optional.Int32
	Names            optional.Interface
	Selectors        optional.String
	Text             optional.String
	UseNewFormat     optional.Bool
}

func (a *SensorsApiService) FindAllLabelValuesInOldFormatUsingGET(ctx context.Context, projectId string, localVarOptionals *SensorsApiFindAllLabelValuesInOldFormatUsingGETOpts) (LabelValuesResponseDto, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue LabelValuesResponseDto
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/v2/projects/{projectId}/sensors/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"projectId"+"}", fmt.Sprintf("%v", projectId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.ValidationFilter.IsSet() {
		localVarQueryParams.Add("_validationFilter", parameterToString(localVarOptionals.ValidationFilter.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ForceCluster.IsSet() {
		localVarQueryParams.Add("forceCluster", parameterToString(localVarOptionals.ForceCluster.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Limit.IsSet() {
		localVarQueryParams.Add("limit", parameterToString(localVarOptionals.Limit.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Names.IsSet() {
		localVarQueryParams.Add("names", parameterToString(localVarOptionals.Names.Value(), "multi"))
	}
	if localVarOptionals != nil && localVarOptionals.Selectors.IsSet() {
		localVarQueryParams.Add("selectors", parameterToString(localVarOptionals.Selectors.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Text.IsSet() {
		localVarQueryParams.Add("text", parameterToString(localVarOptionals.Text.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UseNewFormat.IsSet() {
		localVarQueryParams.Add("useNewFormat", parameterToString(localVarOptionals.UseNewFormat.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json;charset=UTF-8"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v LabelValuesResponseDto
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
SensorsApiService find label names by selector query
This action returns label names by selector query if user have permissions to read that project.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectId projectId
 * @param optional nil or *SensorsApiFindLabelKeysInOldFormatUsingGETOpts - Optional Parameters:
     * @param "ForceCluster" (optional.String) -  force cluster parameter (dc abbreviation or empty)
     * @param "Selectors" (optional.String) -  selector query
     * @param "UseNewFormat" (optional.Bool) -  use new selector query format

@return LabelNamesResponseDto
*/

type SensorsApiFindLabelKeysInOldFormatUsingGETOpts struct {
	ForceCluster optional.String
	Selectors    optional.String
	UseNewFormat optional.Bool
}

func (a *SensorsApiService) FindLabelKeysInOldFormatUsingGET(ctx context.Context, projectId string, localVarOptionals *SensorsApiFindLabelKeysInOldFormatUsingGETOpts) (LabelNamesResponseDto, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue LabelNamesResponseDto
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/v2/projects/{projectId}/sensors/names"
	localVarPath = strings.Replace(localVarPath, "{"+"projectId"+"}", fmt.Sprintf("%v", projectId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.ForceCluster.IsSet() {
		localVarQueryParams.Add("forceCluster", parameterToString(localVarOptionals.ForceCluster.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Selectors.IsSet() {
		localVarQueryParams.Add("selectors", parameterToString(localVarOptionals.Selectors.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UseNewFormat.IsSet() {
		localVarQueryParams.Add("useNewFormat", parameterToString(localVarOptionals.UseNewFormat.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json;charset=UTF-8"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v LabelNamesResponseDto
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
SensorsApiService find all metric names in project
This action returns metric names in project if user have permissions to read that project.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectId projectId
 * @param optional nil or *SensorsApiFindMetricNamesUsingGETOpts - Optional Parameters:
     * @param "ValidationFilter" (optional.String) -  label validation filter (internal parameter, will be removed)
     * @param "ForceCluster" (optional.String) -  force cluster parameter (dc abbreviation or empty)
     * @param "Limit" (optional.Int32) -  metric names count limit [0; 100000]
     * @param "Selectors" (optional.String) -  selector query
     * @param "Text" (optional.String) -  case insensitive text filter by labels

@return MetricNamesResponseDto
*/

type SensorsApiFindMetricNamesUsingGETOpts struct {
	ValidationFilter optional.String
	ForceCluster     optional.String
	Limit            optional.Int32
	Selectors        optional.String
	Text             optional.String
}

func (a *SensorsApiService) FindMetricNamesUsingGET(ctx context.Context, projectId string, localVarOptionals *SensorsApiFindMetricNamesUsingGETOpts) (MetricNamesResponseDto, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue MetricNamesResponseDto
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/v2/projects/{projectId}/sensors/sensorNames"
	localVarPath = strings.Replace(localVarPath, "{"+"projectId"+"}", fmt.Sprintf("%v", projectId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.ValidationFilter.IsSet() {
		localVarQueryParams.Add("_validationFilter", parameterToString(localVarOptionals.ValidationFilter.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.ForceCluster.IsSet() {
		localVarQueryParams.Add("forceCluster", parameterToString(localVarOptionals.ForceCluster.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Limit.IsSet() {
		localVarQueryParams.Add("limit", parameterToString(localVarOptionals.Limit.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Selectors.IsSet() {
		localVarQueryParams.Add("selectors", parameterToString(localVarOptionals.Selectors.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Text.IsSet() {
		localVarQueryParams.Add("text", parameterToString(localVarOptionals.Text.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json;charset=UTF-8"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v MetricNamesResponseDto
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}

/*
SensorsApiService find metrics by selector query
This action returns project&#39;s metric by selector query if user have permissions to read that project.
 * @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectId projectId
 * @param optional nil or *SensorsApiFindMetricsUsingGETOpts - Optional Parameters:
     * @param "ForceCluster" (optional.String) -  force cluster parameter
     * @param "Selectors" (optional.String) -  selector query
     * @param "UseNewFormat" (optional.Bool) -  use new selector query format

@return PagedResultDtoMetricDto
*/

type SensorsApiFindMetricsUsingGETOpts struct {
	ForceCluster optional.String
	Selectors    optional.String
	UseNewFormat optional.Bool
}

func (a *SensorsApiService) FindMetricsUsingGET(ctx context.Context, projectId string, localVarOptionals *SensorsApiFindMetricsUsingGETOpts) (PagedResultDtoMetricDto, *http.Response, error) {
	var (
		localVarHttpMethod  = strings.ToUpper("Get")
		localVarPostBody    interface{}
		localVarFileName    string
		localVarFileBytes   []byte
		localVarReturnValue PagedResultDtoMetricDto
	)

	// create path and map variables
	localVarPath := a.client.cfg.BasePath + "/api/v2/projects/{projectId}/sensors"
	localVarPath = strings.Replace(localVarPath, "{"+"projectId"+"}", fmt.Sprintf("%v", projectId), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if localVarOptionals != nil && localVarOptionals.ForceCluster.IsSet() {
		localVarQueryParams.Add("forceCluster", parameterToString(localVarOptionals.ForceCluster.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.Selectors.IsSet() {
		localVarQueryParams.Add("selectors", parameterToString(localVarOptionals.Selectors.Value(), ""))
	}
	if localVarOptionals != nil && localVarOptionals.UseNewFormat.IsSet() {
		localVarQueryParams.Add("useNewFormat", parameterToString(localVarOptionals.UseNewFormat.Value(), ""))
	}
	// to determine the Content-Type header
	localVarHttpContentTypes := []string{}

	// set Content-Type header
	localVarHttpContentType := selectHeaderContentType(localVarHttpContentTypes)
	if localVarHttpContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHttpContentType
	}

	// to determine the Accept header
	localVarHttpHeaderAccepts := []string{"application/json;charset=UTF-8"}

	// set Accept header
	localVarHttpHeaderAccept := selectHeaderAccept(localVarHttpHeaderAccepts)
	if localVarHttpHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHttpHeaderAccept
	}
	r, err := a.client.prepareRequest(ctx, localVarPath, localVarHttpMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHttpResponse, err := a.client.callAPI(r)
	if err != nil || localVarHttpResponse == nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	localVarBody, err := ioutil.ReadAll(localVarHttpResponse.Body)
	localVarHttpResponse.Body.Close()
	if err != nil {
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode < 300 {
		// If we succeed, return the data, otherwise pass on to decode error.
		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
		return localVarReturnValue, localVarHttpResponse, err
	}

	if localVarHttpResponse.StatusCode >= 300 {
		newErr := GenericSwaggerError{
			body:  localVarBody,
			error: localVarHttpResponse.Status,
		}

		if localVarHttpResponse.StatusCode == 200 {
			var v PagedResultDtoMetricDto
			err = a.client.decode(&v, localVarBody, localVarHttpResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHttpResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHttpResponse, newErr
		}

		return localVarReturnValue, localVarHttpResponse, newErr
	}

	return localVarReturnValue, localVarHttpResponse, nil
}
