package unistat

import (
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
	"log"
	"net/http"
)

type Stats struct {
	SyncCount              *unistat.Numeric
	SyncErrors             *unistat.Numeric
	ProjectsTotal          *unistat.Numeric
	ProjectsWithMonitoring *unistat.Numeric
	ServicesTotal          *unistat.Numeric
	ServicesWithMonitoring *unistat.Numeric
	TestAlertsWarning      *unistat.Numeric
	TestAlertsAlarm        *unistat.Numeric
	TestAlertsTotal        *unistat.Numeric
}

func AbsoluteMaxAggregation() unistat.Aggregation {
	return unistat.StructuredAggregation{
		AggregationType: unistat.Absolute,
		Group:           unistat.Max,
		MetaGroup:       unistat.Max,
		Rollup:          unistat.Max,
	}
}

func MakeStats() *Stats {
	stats := &Stats{
		SyncCount:              unistat.NewNumeric("sync-count", 1, aggr.Counter(), unistat.Sum),
		SyncErrors:             unistat.NewNumeric("sync-errors", 1, aggr.Counter(), unistat.Sum),
		ProjectsTotal:          unistat.NewNumeric("projects-total", 1, AbsoluteMaxAggregation(), unistat.Last),
		ProjectsWithMonitoring: unistat.NewNumeric("projects-monitored", 1, AbsoluteMaxAggregation(), unistat.Last),
		ServicesTotal:          unistat.NewNumeric("services-total", 1, AbsoluteMaxAggregation(), unistat.Last),
		ServicesWithMonitoring: unistat.NewNumeric("services-monitored", 1, AbsoluteMaxAggregation(), unistat.Last),
		TestAlertsWarning:      unistat.NewNumeric("test-alerts-warning", 1, AbsoluteMaxAggregation(), unistat.Last),
		TestAlertsAlarm:        unistat.NewNumeric("test-alerts-alarm", 1, AbsoluteMaxAggregation(), unistat.Last),
		TestAlertsTotal:        unistat.NewNumeric("test-alerts-total", 1, AbsoluteMaxAggregation(), unistat.Last),
	}
	unistat.Register(stats.SyncCount)
	unistat.Register(stats.SyncErrors)
	unistat.Register(stats.ProjectsTotal)
	unistat.Register(stats.ProjectsWithMonitoring)
	unistat.Register(stats.ServicesTotal)
	unistat.Register(stats.ServicesWithMonitoring)
	unistat.Register(stats.TestAlertsWarning)
	unistat.Register(stats.TestAlertsAlarm)
	unistat.Register(stats.TestAlertsTotal)

	return stats
}

func (srv *Stats) ServeHTTP(rw http.ResponseWriter, req *http.Request) {
	bytes, err := unistat.MarshalJSON()
	if err != nil {
		http.Error(rw, err.Error(), http.StatusInternalServerError)
		return
	}

	rw.Header().Set("Content-Type", "application/json; charset=utf-8")
	if _, err := rw.Write(bytes); err != nil {
		log.Print("write:", err)
	}
}
