package util

import (
	"a.yandex-team.ru/library/go/core/log"
	"context"
	"os"
	"os/signal"
	"syscall"
)

func HandleSignals(logger log.Logger, cancel context.CancelFunc) {
	ch := make(chan os.Signal, 1)
	signal.Notify(ch, syscall.SIGINT, syscall.SIGTERM)
	sig := <-ch
	signal.Stop(ch)

	logger.Info("received signal, shutting down", log.String("signal", sig.String()))
	cancel()
}
