package util

import (
	"os"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/yt/go/yt"
	"a.yandex-team.ru/yt/go/yt/ythttp"
)

type YTClientConfig struct {
	Proxy string `yaml:"proxy"`
}

func NewYTClient(logger log.Logger, config YTClientConfig, token string) (yt.Client, error) {
	ytConfig := yt.Config{
		Proxy: config.Proxy,
	}

	if token == "" {
		if token := os.Getenv("YT_TOKEN"); len(token) > 0 {
			logger.Debug("read YT token from environment variable")
			ytConfig.Token = token
		} else {
			logger.Fatal("failed to read YT token from environment variable")
		}
	} else {
		ytConfig.Token = token
	}

	return ythttp.NewClient(&ytConfig)
}
