/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1alpha1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// EDIT THIS FILE!  THIS IS SCAFFOLDING FOR YOU TO OWN!
// NOTE: json tags are required.  Any new fields you add must have json tags for the fields to be serialized.

type AllocationType string

const (
	// User creates pods by himself and specifies pod ids in allocation spec directly
	YpPodIds = "YpPodIds"
	// Pods created by controller. User specify only pod template specs in allocation spec. To be implemented...
	ComputeResourcesRequests = "ComputeResourcesRequests"
)

type AllocationPodRef struct {
	//nolint:ST1003
	// +optional
	Id string `json:"id,omitempty"`
	// +optional
	Cluster string `json:"cluster,omitempty"`
}

type AllocationYpPodIds struct {
	// +optional
	Pods []AllocationPodRef `json:"pods"`
}

// AllocationSpec defines the desired state of Allocation
type AllocationSpec struct {
	// +optional
	Type AllocationType `json:"type,omitempty"`
	// +optional
	YpPodIds *AllocationYpPodIds `json:"ypPodIds,omitempty"`
	// +optional
	// +kubebuilder:validation:Enum="";ACTIVE;PREPARED
	// If set it will be used to replace ACTIVE target state in pod's ISS confs.
	// For example sometimes it is useful to create pods in PREPARED target state and then move them to ACTIVE manually.
	ISSActiveTargetStateReplacement string `json:"issActiveTargetStateReplacement"`
	// +optional
	// +kubebuilder:validation:Enum="";FAIL_ON_REMOVED_PODS;IGNORE_REMOVED_PODS
	// Determines how to resolve pods specified in allocation. Possible values:
	//   * Empty string: default behavior which preferred to be the same as FAIL_ON_REMOVED_PODS
	//   * FAIL_ON_REMOVED_PODS: fail on generating/activating/deactivating/destroying runtime-snapshot if allocation contains references to removed pods
	//   * IGNORE_REMOVED_PODS: ingnore removed pods on generating/activating/deactivating/destroying runtime-snapshot.
	PodsResolvingPolicy string `json:"podsResolvingPolicy"`
}

// AllocationStatus defines the observed state of Allocation
type AllocationStatus struct {
}

// +genclient
// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// Allocation is the Schema for the allocations API
type Allocation struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   AllocationSpec   `json:"spec,omitempty"`
	Status AllocationStatus `json:"status,omitempty"`
}

// +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object

// AllocationList contains a list of Allocation
type AllocationList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata,omitempty"`
	Items           []Allocation `json:"items"`
}
