/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "a.yandex-team.ru/infra/allocation-ctl/pkg/apis/allocationctl/v1alpha1"
	scheme "a.yandex-team.ru/infra/allocation-ctl/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AllocationsGetter has a method to return a AllocationInterface.
// A group's client should implement this interface.
type AllocationsGetter interface {
	Allocations(namespace string) AllocationInterface
}

// AllocationInterface has methods to work with Allocation resources.
type AllocationInterface interface {
	Create(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.CreateOptions) (*v1alpha1.Allocation, error)
	Update(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.UpdateOptions) (*v1alpha1.Allocation, error)
	UpdateStatus(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.UpdateOptions) (*v1alpha1.Allocation, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Allocation, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.AllocationList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Allocation, err error)
	AllocationExpansion
}

// allocations implements AllocationInterface
type allocations struct {
	client rest.Interface
	ns     string
}

// newAllocations returns a Allocations
func newAllocations(c *NannyV1alpha1Client, namespace string) *allocations {
	return &allocations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the allocation, and returns the corresponding allocation object, and an error if there is any.
func (c *allocations) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Allocation, err error) {
	result = &v1alpha1.Allocation{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("allocations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Allocations that match those selectors.
func (c *allocations) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AllocationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AllocationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("allocations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested allocations.
func (c *allocations) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("allocations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a allocation and creates it.  Returns the server's representation of the allocation, and an error, if there is any.
func (c *allocations) Create(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.CreateOptions) (result *v1alpha1.Allocation, err error) {
	result = &v1alpha1.Allocation{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("allocations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(allocation).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a allocation and updates it. Returns the server's representation of the allocation, and an error, if there is any.
func (c *allocations) Update(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.UpdateOptions) (result *v1alpha1.Allocation, err error) {
	result = &v1alpha1.Allocation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("allocations").
		Name(allocation.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(allocation).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *allocations) UpdateStatus(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.UpdateOptions) (result *v1alpha1.Allocation, err error) {
	result = &v1alpha1.Allocation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("allocations").
		Name(allocation.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(allocation).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the allocation and deletes it. Returns an error if one occurs.
func (c *allocations) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("allocations").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *allocations) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("allocations").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched allocation.
func (c *allocations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Allocation, err error) {
	result = &v1alpha1.Allocation{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("allocations").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
