/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "a.yandex-team.ru/infra/allocation-ctl/pkg/apis/allocationctl/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeAllocations implements AllocationInterface
type FakeAllocations struct {
	Fake *FakeNannyV1alpha1
	ns   string
}

var allocationsResource = schema.GroupVersionResource{Group: "nanny.yandex-team.ru", Version: "v1alpha1", Resource: "allocations"}

var allocationsKind = schema.GroupVersionKind{Group: "nanny.yandex-team.ru", Version: "v1alpha1", Kind: "Allocation"}

// Get takes name of the allocation, and returns the corresponding allocation object, and an error if there is any.
func (c *FakeAllocations) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Allocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(allocationsResource, c.ns, name), &v1alpha1.Allocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Allocation), err
}

// List takes label and field selectors, and returns the list of Allocations that match those selectors.
func (c *FakeAllocations) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AllocationList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(allocationsResource, allocationsKind, c.ns, opts), &v1alpha1.AllocationList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.AllocationList{ListMeta: obj.(*v1alpha1.AllocationList).ListMeta}
	for _, item := range obj.(*v1alpha1.AllocationList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested allocations.
func (c *FakeAllocations) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(allocationsResource, c.ns, opts))

}

// Create takes the representation of a allocation and creates it.  Returns the server's representation of the allocation, and an error, if there is any.
func (c *FakeAllocations) Create(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.CreateOptions) (result *v1alpha1.Allocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(allocationsResource, c.ns, allocation), &v1alpha1.Allocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Allocation), err
}

// Update takes the representation of a allocation and updates it. Returns the server's representation of the allocation, and an error, if there is any.
func (c *FakeAllocations) Update(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.UpdateOptions) (result *v1alpha1.Allocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(allocationsResource, c.ns, allocation), &v1alpha1.Allocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Allocation), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeAllocations) UpdateStatus(ctx context.Context, allocation *v1alpha1.Allocation, opts v1.UpdateOptions) (*v1alpha1.Allocation, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(allocationsResource, "status", c.ns, allocation), &v1alpha1.Allocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Allocation), err
}

// Delete takes name of the allocation and deletes it. Returns an error if one occurs.
func (c *FakeAllocations) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(allocationsResource, c.ns, name), &v1alpha1.Allocation{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeAllocations) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(allocationsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.AllocationList{})
	return err
}

// Patch applies the patch and returns the patched allocation.
func (c *FakeAllocations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Allocation, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(allocationsResource, c.ns, name, pt, data, subresources...), &v1alpha1.Allocation{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Allocation), err
}
