/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	allocationctlv1alpha1 "a.yandex-team.ru/infra/allocation-ctl/pkg/apis/allocationctl/v1alpha1"
	versioned "a.yandex-team.ru/infra/allocation-ctl/pkg/generated/clientset/versioned"
	internalinterfaces "a.yandex-team.ru/infra/allocation-ctl/pkg/generated/informers/externalversions/internalinterfaces"
	v1alpha1 "a.yandex-team.ru/infra/allocation-ctl/pkg/generated/listers/allocationctl/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// AllocationInformer provides access to a shared informer and lister for
// Allocations.
type AllocationInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.AllocationLister
}

type allocationInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewAllocationInformer constructs a new informer for Allocation type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAllocationInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAllocationInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredAllocationInformer constructs a new informer for Allocation type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAllocationInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.NannyV1alpha1().Allocations(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.NannyV1alpha1().Allocations(namespace).Watch(context.TODO(), options)
			},
		},
		&allocationctlv1alpha1.Allocation{},
		resyncPeriod,
		indexers,
	)
}

func (f *allocationInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAllocationInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *allocationInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&allocationctlv1alpha1.Allocation{}, f.defaultInformer)
}

func (f *allocationInformer) Lister() v1alpha1.AllocationLister {
	return v1alpha1.NewAllocationLister(f.Informer().GetIndexer())
}
