/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "a.yandex-team.ru/infra/allocation-ctl/pkg/apis/allocationctl/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// AllocationLister helps list Allocations.
// All objects returned here must be treated as read-only.
type AllocationLister interface {
	// List lists all Allocations in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.Allocation, err error)
	// Allocations returns an object that can list and get Allocations.
	Allocations(namespace string) AllocationNamespaceLister
	AllocationListerExpansion
}

// allocationLister implements the AllocationLister interface.
type allocationLister struct {
	indexer cache.Indexer
}

// NewAllocationLister returns a new AllocationLister.
func NewAllocationLister(indexer cache.Indexer) AllocationLister {
	return &allocationLister{indexer: indexer}
}

// List lists all Allocations in the indexer.
func (s *allocationLister) List(selector labels.Selector) (ret []*v1alpha1.Allocation, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Allocation))
	})
	return ret, err
}

// Allocations returns an object that can list and get Allocations.
func (s *allocationLister) Allocations(namespace string) AllocationNamespaceLister {
	return allocationNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// AllocationNamespaceLister helps list and get Allocations.
// All objects returned here must be treated as read-only.
type AllocationNamespaceLister interface {
	// List lists all Allocations in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.Allocation, err error)
	// Get retrieves the Allocation from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.Allocation, error)
	AllocationNamespaceListerExpansion
}

// allocationNamespaceLister implements the AllocationNamespaceLister
// interface.
type allocationNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Allocations in the indexer for a given namespace.
func (s allocationNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Allocation, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Allocation))
	})
	return ret, err
}

// Get retrieves the Allocation from the indexer for a given namespace and name.
func (s allocationNamespaceLister) Get(name string) (*v1alpha1.Allocation, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("allocation"), name)
	}
	return obj.(*v1alpha1.Allocation), nil
}
