package issutil

import (
	repopb "a.yandex-team.ru/infra/nanny/go/proto/nanny_repo"
	"bytes"
	"fmt"
)

const (
	YASMAgentPath = "/usr/local/yasmagent"
)

func MakeBindProperty(daemons []*repopb.HostProvidedDaemon) (string, error) {
	b := &bytes.Buffer{}
	written := false
	for _, d := range daemons {
		if d.GetType() == repopb.HostProvidedDaemon_YASM_AGENT {
			var f string
			if written {
				f = "; %s %s ro"
			} else {
				f = "%s %s ro"
			}
			if _, err := fmt.Fprintf(b, f, YASMAgentPath, YASMAgentPath); err != nil {
				return "", fmt.Errorf("failed to generate bind property for host provided daemon type %s: %w", d.GetType().String(), err)
			}
			written = true
		} else if d.GetType() != repopb.HostProvidedDaemon_HOST_SKYNET {
			return "", fmt.Errorf("unknown container host provided subagent type")
		}
	}
	return b.String(), nil
}
