package metricsutil

import (
	"a.yandex-team.ru/library/go/yandex/unistat"
	"time"
)

var DefaultHistogramIntervalsSeconds = []float64{
	.0001, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20,
	25, 30, 35, 40, 45, 50, 55, 60,
	70, 80, 90, 100, 110, 120,
	140, 160, 180, 200,
	200, 250,
	350, 450,
	725, 1000,
}

func MeasureSecondsSince(m unistat.Updater, ts time.Time) {
	dur := time.Since(ts)
	m.Update(dur.Seconds()) // to seconds
}
