package server

import (
	"a.yandex-team.ru/infra/allocation-ctl/pkg/log"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"net/http"
)

func UnistatHandle(rw http.ResponseWriter, req *http.Request) {
	bytes, err := unistat.MarshalJSON()
	if err != nil {
		http.Error(rw, err.Error(), http.StatusInternalServerError)
		return
	}

	rw.Header().Set("Content-Type", "application/json; charset=utf-8")
	if _, err := rw.Write(bytes); err != nil {
		log.Errorf("[unistat-handler] failed to send metrics: %s", err)
	}
}
