package api

const (
	DefaultGetObjectsBatchSize    = 500
	DefaultSelectIDsBatchSize     = 1000
	DefaultGetObjectsThreadsCount = 4
	MetaSelector                  = "/meta"
	SpecSelector                  = "/spec"
)

var DefaultGetObjectsSelectors = []string{MetaSelector, SpecSelector, "/status"}
var DefaultSelectIDsSelectors = []string{MetaSelector}

type ListOptions struct {
	Filter                 string
	Selectors              []string
	FetchTimestamps        bool
	SelectIDsBatchSize     int32
	GetObjectsBatchSize    int32
	GetObjectsThreadsCount int
	SpecIdx                int8
}

func GetDefaultListOptions(fetchTimestamps bool) ListOptions {
	opts := ListOptions{
		Filter:                 "",
		Selectors:              DefaultGetObjectsSelectors,
		GetObjectsBatchSize:    DefaultGetObjectsBatchSize,
		SelectIDsBatchSize:     DefaultSelectIDsBatchSize,
		GetObjectsThreadsCount: DefaultGetObjectsThreadsCount,
		FetchTimestamps:        fetchTimestamps,
	}
	opts.SpecIdx = -1
	for i, v := range opts.Selectors {
		if v == SpecSelector {
			opts.SpecIdx = int8(i)
			break
		}
	}
	return opts
}
