package ypclient

import (
	"a.yandex-team.ru/infra/allocation-ctl/pkg/metricsutil"
	"a.yandex-team.ru/infra/allocation-ctl/pkg/yp/rpc"
	"a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
	"a.yandex-team.ru/yp/go/yp"
	"fmt"
)

// YPClient implements PodsGetter
type YPClient struct {
	rpcClient   rpc.RPCInterface
	podsMetrics *podsMetrics
}

func NewYPClientFromCluster(cluster string) (ypClient *YPClient, err error) {
	base, err := yp.NewClient(cluster, yp.WithSystemAuthToken())
	if err != nil {
		return nil, err
	}
	rpcClient := rpc.NewClient(base, cluster)
	return &YPClient{
		rpcClient:   rpcClient,
		podsMetrics: newPodsMetrics(cluster),
	}, nil
}

func (c *YPClient) Pods() PodInterface {
	return newPods(c)
}

type podsMetrics struct {
	listTime *unistat.Histogram
	count    *unistat.Numeric
}

func newPodsMetrics(cluster string) *podsMetrics {
	rv := &podsMetrics{
		listTime: unistat.NewHistogram(fmt.Sprintf("pods-list-time-%s", cluster), 0, aggr.Histogram(), metricsutil.DefaultHistogramIntervalsSeconds),
		count:    unistat.NewNumeric(fmt.Sprintf("pods-count-%s", cluster), 0, aggr.Absolute(), unistat.Last),
	}
	unistat.Register(rv.listTime)
	unistat.Register(rv.count)
	return rv
}
