
import json


def decrease_limits():

    data = json.load(open("hdd_limits_v2_formatted.json"))

    for serv in data:

        vols = serv["volumes"]
        total_guarantee = 0

        for vol in vols:
            total_guarantee += vol["guarantee"]

        if total_guarantee > 78:
            for vol in vols:
                vol["guarantee"] = max(int(vol["guarantee"] / 2), 5)

    json.dump(data, open("hdd_limits_v2_decreased.json", "w"))


if __name__ == '__main__':
    decrease_limits()
