
import pickle
from yp.client import YpClient, find_token


def get_balancer_guarantee(podname, cluster):

    with YpClient(cluster, config=dict(token=find_token())) as yp_client:
        result = yp_client.select_objects("pod", selectors=["/spec/resource_requests/vcpu_guarantee"],
                                         filter="[/meta/id]='{0}'".format(podname),
                                         enable_structured_response=True)
        try:
            cpu_guarantee = result["results"][0][0]["value"] / 1000
        except IndexError:
            return None

        if cpu_guarantee < 2:
            return 15
        elif 2 <= cpu_guarantee < 3:
            return 20
        else:
            return 30


# TODO: поддержать балансеры в других системах деплоя
def process_balancers(metadata_file):

    # мерджим новые балансеры
    data = pickle.load(open(metadata_file, "rb"))
    balancer_guarantees = []

    try:
        for host, pods in data.items():
            for pod in pods:
                if "balancer" in pod["service_name"]:
                    _podname, dc = pod["pod_name"], pod["dc"]

                    print(_podname, dc)
                    guarantee = get_balancer_guarantee(_podname, dc)
                    if guarantee:
                        limit = guarantee * 2
                        res_obj = {
                            "deploy_engine": "YP_LITE",
                            "service_id": pod["service_name"],
                            "volumes": [
                                {
                                    "mount_path": "/logs",
                                    "storage_class": "hdd",
                                    "guarantee": guarantee,
                                    "limit": limit
                                }
                        ]
                        }
                        balancer_guarantees.append(res_obj)
                        print("another balancer has been processed")
    except:
        pass

    return balancer_guarantees
