# coding: utf-8

from __future__ import absolute_import, print_function

import os
import logging
from collections import defaultdict
import pickle
import requests
import argparse

OAUTH_TOKEN = os.environ.get("OAUTH_TOKEN", "")
ST_OAUTH_TOKEN = os.environ.get("ST_OAUTH_TOKEN", "")
NANNY_OAUTH_TOKEN = os.environ.get("NANNY_OAUTH_TOKEN", "")
SOLOMON_TOKEN = os.environ.get("SOLOMON_TOKEN", "")
YQL_TOKEN = os.environ.get("YQL_TOKEN", "")
YT_TOKEN = os.environ.get("YT_TOKEN", "")


signals_group_mapping = {
    "ssd": "portoinst-io_read_bytes_/ssd_tmmv||portoinst-io_read_bytes_/place_tmmv||portoinst-io_ops_/place_tmmv||"
            "portoinst-io_ops_/ssd_tmmv||portoinst-cpu_usage_cores_tmmv||portoinst-io_write_fs_bytes_tmmv||"
            "portoinst-io_serviced_/place_read_hgram",
    "hdd": "portoinst-io_read_bytes_/ssd_tmmv||portoinst-io_read_bytes_/place_tmmv||portoinst-io_ops_/place_tmmv||"
            "portoinst-io_ops_/ssd_tmmv||portoinst-cpu_usage_cores_tmmv||portoinst-io_write_fs_bytes_tmmv||"
            "portoinst-io_serviced_/place_read_hgram",
    "ssd_write": "portoinst-io_write_bytes_/ssd_tmmv||portoinst-io_write_bytes_/place_tmmv||portoinst-io_ops_/place_tmmv||"
            "portoinst-io_ops_/ssd_tmmv||portoinst-cpu_usage_cores_tmmv||portoinst-io_write_fs_bytes_tmmv||"
            "portoinst-io_serviced_/place_read_hgram",
    "net": "portoinst-io_read_bytes_/ssd_tmmv||portoinst-io_read_bytes_/place_tmmv||portoinst-cpu_usage_cores_tmmv||"
           "portoinst-net_rx_mb_summ||portoinst-net_tx_mb_summ||"
           "portoinst-net_rx_packets_summ||portoinst-net_tx_packets_summ||portoinst-memory_usage_gb_tmmv",
}


signals_group_mapping["net_balancer"] = "||".join(
    [
        signals_group_mapping["net"],
        "balancer_report-report-service_total-input_size_hgram",
        "balancer_report-report-service_total-output_size_hgram"
    ]
)

signals_group_mapping["net_balancer_test"] = "balancer_report-report-service_total-input_size_hgram"



BUSY_DIRS_SSD = {
    "/amqp_data",
    "/cache",
    "/cm",
    "/dajr",
    "/data",
    "/data/db",
    "/data_ssd",
    "/db",
    "/db/bsconfig/webcache",
    "/db/bsconfig/webstate",
    "/db/mysql",
    "/ephemeral",
    "/fastbuild",
    "/fast_data",
    "/fresh",
    "/graph",
    "/local",
    "/mongo",
    "/opt/zookeeper",
    "/persistent",
    "/rem",
    "/resources",
    "/shard_root",
    "/ssd",
    "/state",
    "/storage",
    "/usr/local/teamcity-agents",
    "/var/bases",
    "/var/cache/nginx",
    "/var/cache/yandex",
    "/var/exports",
    "/var/lib/etcd",
    "/var/lib/nginx",
    "/var/lib/teamcity",
    "/var/lib/yandex/maps/carparks",
    "/var/lib/yandex/maps/ecstatic",
    "/var/lib/yandex/tanker",
    "/var/www/layers-mobile/carparks",
    "/xurma",
    "/zoo_data"
}


BUSY_DIRS_HDD = {
  "/cache",
  "/cocaine",
  "/coredumps",
  "/data",
  "/data1",
  "/data2",
  "/data3",
  "/db/bsconfig/webstate",
  "/db/mysql",
  "/ephemeral",
  "/etcd_data",
  "/fresh",
  "/gear",
  "/graph",
  "/images",
  "/joker_stubs",
  "/local",
  "/morkva",
  "/perm",
  "/persistent",
  "/persistent-data",
  "/place",
  "/rem",
  "/resources",
  "/resources_storage",
  "/sandbox",
  "/srv",
  "/state",
  "/storage",
  "/tmp",
  "/var/bases",
  "/var/cache/yandex",
  "/var/exports",
  "/var/hdd_place",
  "/var/lib/ichwill",
  "/var/lib/push-client",
  "/var/lib/teamcity",
  "/var/lib/yandex/maps/ecstatic",
  "/var/lib/yandex/maps/wiki/stat",
  "/var/spool",
  "/var/spool/ichwill",
  "/webstate",
  "/worker_data",
  "/xurma",
  "/zen"
}


AUTOMATED_GENERATED_LIMITS = "//home/runtimecloud/research/io_research/io_read_ssd_95_automated"
AUTOMATED_GENERATED_RAW_LIMITS = "//home/runtimecloud/research/io_research/io_read_ssd_95_automated"
AUTOMATED_GENERATED_RAW_DATA = "//home/runtimecloud/research/io_research/ssd_io_read_automated"
AUTOMATED_GENERATED_LIMITS_NET = "//home/runtimecloud/research/net_95_30_automated"
META_DATA = "//home/runtimecloud/research/io_research/meta_pod_data"


def read_token():
    global OAUTH_TOKEN
    if OAUTH_TOKEN:
        return
    try:
        with open(os.path.expanduser("~/.yp/token")) as stream:
            OAUTH_TOKEN = stream.read().strip()
    except Exception:
        logging.exception("Can't get token")


def read_yt_token():
    global YT_TOKEN

    if YT_TOKEN:
        return
    else:
        logging.exception("Can't get solomon token")


def read_solomon_token():
    global SOLOMON_TOKEN

    if SOLOMON_TOKEN:
        return
    else:
        logging.exception("Can't get solomon token")


def read_yql_token():
    global YQL_TOKEN

    if YQL_TOKEN:
        return
    try:
        with open(os.path.expanduser("~/.yql/token")) as stream:
            YQL_TOKEN = stream.read().strip()
    except Exception:
        logging.exception("Can't get token")


def read_st_token():
    global ST_OAUTH_TOKEN
    if ST_OAUTH_TOKEN:
        return
    try:
        with open(os.path.expanduser("~/.st/token")) as stream:
            ST_OAUTH_TOKEN = stream.read().strip()
    except Exception:
        logging.exception("Can't get st token")


def read_nanny_token():
    global NANNY_OAUTH_TOKEN
    if NANNY_OAUTH_TOKEN:
        return
    try:
        with open(os.path.expanduser("~/.nanny/token")) as stream:
            NANNY_OAUTH_TOKEN = stream.read().strip()
    except Exception:
        logging.exception("Can't get nanny token")


def get_oauth_token():
    return OAUTH_TOKEN


def get_solomon_token():
    return SOLOMON_TOKEN


def get_yql_token():
    return YQL_TOKEN


def get_st_oauth_token():
    return ST_OAUTH_TOKEN


def get_nanny_oauth_token():
    return NANNY_OAUTH_TOKEN


def get_yt_token():
    return YT_TOKEN


def iter_abc_members():
    url_template = "https://abc-back.yandex-team.ru/api/v4/services/members/?cursor={}-0&ordering=id&fields=id,person.id,person.login,service.id,role.scope.slug"
    cursor_id = 0
    while True:
        reply = requests.get(url_template.format(cursor_id), headers={"Authorization": "OAuth {}".format(get_st_oauth_token())}).json()
        for row in reply["results"]:
            cursor_id = max(cursor_id, row["id"])
            if row["role"]["scope"]["slug"] not in ("services_management", "administration"):
                continue
            if row["person"]["login"].startswith("robot-") or row["person"]["login"].endswith("-robot"):
                continue
            yield int(row["service"]["id"]), row["person"]["id"], row["person"]["login"]
        if not reply["results"]:
            break


def get_abc_members_cached():
    file_name = "abc_members_cache.tmp"
    try:
        with open(file_name, "r") as stream:
            return pickle.load(stream)
    except Exception:
        result = defaultdict(list)
        for abc_service_id, person_id, login in iter_abc_members():
            result[abc_service_id].append((person_id, login))
        result = dict(result)
        with open(file_name, "w") as stream:
            pickle.dump(result, stream)
        return result


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


def iter_abc_services():
    url_template = "https://abc-back.yandex-team.ru/api/v4/services/?page={}&ordering=id&fields=id,name,slug"
    page = 1
    while True:
        reply = requests.get(url_template.format(page), headers={"Authorization": "OAuth {}".format(get_st_oauth_token())}).json()
        page += 1
        for row in reply.get("results", []):
            yield int(row["id"]), row["name"], row["slug"]
        if not reply.get("results"):
            break


def get_abc_services_cached():
    file_name = "abc_services_cache.tmp"
    try:
        with open(file_name, "r") as stream:
            return pickle.load(stream)
    except Exception:
        result = {}
        for abc_service_id, name, slug in iter_abc_services():
            result[abc_service_id] = (name, slug)
        with open(file_name, "w") as stream:
            pickle.dump(result, stream)
        return result


if __name__ == '__main__':
    print(signals_group_mapping["net_balancer"])
