package ru.yandex.infra.auth.dto;

import java.util.List;
import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.controller.dto.ProjectMeta;

public class ProjectInfo {
    private final List<String> userSpecificBoxes;
    private final String owner;
    private final String accountId;
    private final String originState;
    private final ProjectMeta meta;

    public ProjectInfo(ProjectMeta meta, List<String> userSpecificBoxes, String owner, String accountId) {
        this(meta, userSpecificBoxes, owner, accountId, "");
    }

    public ProjectInfo(ProjectMeta meta, List<String> userSpecificBoxes, String owner, String accountId, String originStage) {
        this.meta = meta;
        this.userSpecificBoxes = userSpecificBoxes;
        this.owner = owner;
        this.accountId = accountId;
        this.originState = originStage;
    }

    public ProjectMeta getMeta() {
        return meta;
    }

    public List<String> getUserSpecificBoxes() {
        return userSpecificBoxes;
    }

    public String getOwner() {
        return owner;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getOriginStage() {
        return originState;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectInfo)) {
            return false;
        }
        ProjectInfo that = (ProjectInfo) o;
        return Objects.equals(meta, that.meta) &&
                Objects.equals(userSpecificBoxes, that.userSpecificBoxes) &&
                Objects.equals(owner, that.owner) &&
                Objects.equals(accountId, that.accountId) &&
                Objects.equals(originState, that.originState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(meta, userSpecificBoxes, owner, accountId, originState);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("meta", meta)
                .add("userSpecificBoxes", userSpecificBoxes)
                .add("owner", owner)
                .add("accountId", accountId)
                .add("originState", originState)
                .toString();
    }
}
