package ru.yandex.infra.auth.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.controller.dto.StageMeta;

public class StageMetaWithAccount {
    private final StageMeta meta;
    private final String accountId;

    public StageMetaWithAccount(StageMeta meta, String accountId) {
        this.meta = meta;
        this.accountId = accountId;
    }

    public StageMeta getMeta() {
        return meta;
    }

    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StageMetaWithAccount)) {
            return false;
        }
        StageMetaWithAccount that = (StageMetaWithAccount) o;
        return Objects.equals(meta, that.meta) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(meta, accountId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("meta", meta)
                .add("accountId", accountId)
                .toString();
    }
}
