package ru.yandex.infra.auth.idm.api;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

public class AddGroupSubjectRequest extends AddSubjectRequest {
    private final Long group;

    public AddGroupSubjectRequest(String system, String path, Long group) {
        super(system, path);
        this.group = group;
    }

    @JsonProperty("group")
    public Long getGroup() {
        return group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddGroupSubjectRequest)) {
            return false;
        }
        AddGroupSubjectRequest that = (AddGroupSubjectRequest) o;
        return super.equals(o) &&
                Objects.equals(group, that.group);
    }

    @Override
    public int hashCode() {
        return Objects.hash(system, path, group);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("system", system)
                .add("path", path)
                .add("group", group)
                .toString();
    }
}
