package ru.yandex.infra.auth.idm.api;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

import ru.yandex.infra.auth.idm.service.IdmName;

final class AddNodeRequest extends BatchRequest {
    AddNodeRequest(AddNodeRequestBody body) {
        super(Method.POST, "/rolenodes/", body);
    }

    public static class AddNodeRequestBody extends BatchRequest.BatchBody {
        private static final String PATH_DELIMITER = "/";

        private final IdmName name;
        private final IdmName help;
        private final String slug;
        private final String system;
        private final String parent;
        private final String uniqueId;

        AddNodeRequestBody(IdmName name, IdmName help, String slug, String system, String parent, String uniqueId) {
            this.name = name;
            this.help = help;
            this.slug = slug;
            this.system = system;
            this.parent = parent;
            this.uniqueId = uniqueId;
        }

        @JsonProperty("name")
        public IdmName getName() {
            return name;
        }

        @JsonProperty("help")
        public IdmName getHelp() {
            return help;
        }

        @JsonProperty("slug")
        public String getSlug() {
            return slug;
        }

        @JsonProperty("system")
        public String getSystem() {
            return system;
        }

        @JsonProperty("parent")
        public String getParent() {
            return parent;
        }

        @JsonProperty("unique_id")
        public String getUniqueId() {
            return uniqueId;
        }

        public String getPath() {
            return parent + name.getEnName() + PATH_DELIMITER;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddNodeRequestBody)) {
                return false;
            }
            AddNodeRequestBody that = (AddNodeRequestBody) o;
            return Objects.equals(name, that.name) &&
                    Objects.equals(help, that.help) &&
                    Objects.equals(slug, that.slug) &&
                    Objects.equals(system, that.system) &&
                    Objects.equals(parent, that.parent) &&
                    Objects.equals(uniqueId, that.uniqueId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(name, help, slug, system, parent, uniqueId);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this)
                    .add("name", name)
                    .add("help", help)
                    .add("slug", slug)
                    .add("system", system)
                    .add("parent", parent)
                    .add("uniqueId", uniqueId)
                    .toString();
        }
    }
}
