package ru.yandex.infra.auth.idm.api;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

public class AddSubjectRequest extends BatchRequest.BatchBody {
    protected final String system;
    protected final String path;

    protected AddSubjectRequest(String system, String path) {
        this.system = system;
        this.path = path;
    }

    @JsonProperty("system")
    public String getSystem() {
        return system;
    }

    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddSubjectRequest)) {
            return false;
        }
        AddSubjectRequest that = (AddSubjectRequest) o;
        return Objects.equals(system, that.system) &&
                Objects.equals(path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(system, path);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("system", system)
                .add("path", path)
                .toString();
    }
}
