package ru.yandex.infra.auth.idm.api;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

public class AddUserSubjectRequest extends AddSubjectRequest {
    private final String user;

    public AddUserSubjectRequest(String system, String path, String user) {
        super(system, path);
        this.user = user;
    }

    @JsonProperty("user")
    public String getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddUserSubjectRequest)) {
            return false;
        }
        AddUserSubjectRequest that = (AddUserSubjectRequest) o;
        return super.equals(o) &&
                Objects.equals(user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(system, path, user);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("system", system)
                .add("path", path)
                .add("user", user)
                .toString();
    }
}
