package ru.yandex.infra.auth.idm.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;

final class BatchResponse {
    private final List<Response> responses;
    private final int statusCode;

    BatchResponse(int statusCode, List<Response> responses) {
        this.statusCode = statusCode;
        this.responses = responses;
    }

    public List<Response> getResponses() {
        return responses;
    }

    public int getStatusCode() {
        return statusCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchResponse)) {
            return false;
        }
        BatchResponse that = (BatchResponse) o;
        return Objects.equals(responses, that.responses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(responses);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("statusCode", statusCode)
                .add("responses", responses)
                .toString();
    }

    public static class Builder {
        private List<Response> responses = new ArrayList<>();
        private int statusCode = 0;

        public Builder addStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder addResponse(Response response) {
            responses.add(response);
            return this;
        }

        public BatchResponse build() {
            return new BatchResponse(statusCode, responses);
        }
    }

    public static class Response extends HttpResponse {
        private final String id;

        Response(String id, int statusCode, String statusMessage) {
            super(statusCode, statusMessage);
            this.id = id;
        }

        public static Response fromJsonNode(JsonNode node, String statusMessage) {
            return new Response(node.get("id").asText(), node.get("status_code").asInt(), statusMessage);
        }

        public String getId() {
            return id;
        }

        @Override
        public String toString() {
            return "\n" + MoreObjects.toStringHelper(this)
                    .add("id", id)
                    .add("statusCode", getStatusCode())
                    .add("statusType", getStatusType())
                    .add("statusMessage", getStatusMessage())
                    .toString();
        }
    }
}
