package ru.yandex.infra.auth.idm.api;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class HttpResponse {
    private final int statusCode;
    private final Status statusType;
    private final String statusMessage;

    public HttpResponse(int statusCode, String statusMessage) {
        this.statusCode = statusCode;
        this.statusType = Status.values()[statusCode / 100 - 1];
        this.statusMessage = statusMessage;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public Status getStatusType() {
        return statusType;
    }

    public String getStatusMessage() {
        return statusMessage;
    }

    public boolean isServerError() {
        return statusType == Status.SERVER_ERROR;
    }

    public boolean isClientError() {
        return statusType == Status.CLIENT_ERROR;
    }

    public boolean isSuccess() {
        return statusType == Status.SUCCESS;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse that = (HttpResponse) o;
        return Objects.equals(statusType, that.statusType) &&
                Objects.equals(statusMessage, that.statusMessage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(statusType, statusMessage);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("statusCode", statusCode)
                .add("statusType", statusType)
                .add("statusMessage", statusMessage)
                .toString();
    }

    public enum Status {
        INFO,
        SUCCESS,
        REDIRECT,
        CLIENT_ERROR,
        SERVER_ERROR
    }
}
