package ru.yandex.infra.auth.idm.api;

import java.util.Objects;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;

import ru.yandex.infra.auth.idm.service.IdmName;

class RoleNodeInfo {
    private static final String[] USED_IDM_NODE_FIELDS = {
            "help",
            "id",
            "slug",
            "parent_path",
            "value_path",
            "is_key",
            "unique_id"
    };
    public static final String LIST_OF_FIELDS_FOR_IDM_NODES_API_REQUEST = String.join(",", USED_IDM_NODE_FIELDS);

    private final long id;
    private final IdmName help;
    private final String slug;
    private final String parentPath;
    private final String valuePath;
    private final boolean isKey;
    private final String uniqueId;

    RoleNodeInfo(long id, IdmName help, String slug, String parentPath, String valuePath, boolean isKey, String uniqueId) {
        this.id = id;
        this.help = help;
        this.slug = slug;
        this.parentPath = parentPath;
        this.valuePath = valuePath;
        this.isKey = isKey;
        this.uniqueId = uniqueId;
    }

    public static RoleNodeInfo fromJsonNode(JsonNode node) {
        return new RoleNodeInfo(
                node.get("id").longValue(),
                IdmName.fromJsonNode(node.get("help")),
                node.get("slug").textValue(),
                node.get("parent_path").textValue(),
                node.get("value_path").textValue(),
                node.get("is_key").booleanValue(),
                node.get("unique_id").textValue());
    }

    public long getId() {
        return id;
    }

    public IdmName getHelp() {
        return help;
    }

    public String getSlug() {
        return slug;
    }

    public String getValuePath() {
        return valuePath;
    }

    public String getParentPath() {
        return parentPath;
    }

    public boolean isKey() {
        return isKey;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleNodeInfo)) {
            return false;
        }
        RoleNodeInfo that = (RoleNodeInfo) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(help, that.help) &&
                Objects.equals(parentPath, that.parentPath) &&
                Objects.equals(valuePath, that.valuePath) &&
                Objects.equals(uniqueId, that.uniqueId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(help, parentPath, valuePath, uniqueId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("help", help)
                .add("parentPath", parentPath)
                .add("valuePath", valuePath)
                .add("uniqueId", uniqueId)
                .toString();
    }
}
