package ru.yandex.infra.auth.idm.api;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;

public class RoleNodesResponse {
    private final int limit;
    private final String next;
    private final int offset;
    private final String previous;
    private final int totalCount;
    private final List<RoleNodeInfo> nodes;

    public RoleNodesResponse(int limit, String next, int offset, String previous, int totalCount, List<RoleNodeInfo> nodes) {
        this.limit = limit;
        this.next = next;
        this.offset = offset;
        this.previous = previous;
        this.totalCount = totalCount;
        this.nodes = nodes;
    }

    public static RoleNodesResponse fromJsonNode(JsonNode rootNode) {

        List<RoleNodeInfo> roleTreeNodes = new ArrayList<>();
        rootNode.get("objects").forEach(node -> roleTreeNodes.add(RoleNodeInfo.fromJsonNode(node)));

        JsonNode metaNode = rootNode.get("meta");
        return new RoleNodesResponse(
                metaNode.get("limit").intValue(),
                metaNode.get("next").textValue(),
                metaNode.get("offset").intValue(),
                metaNode.get("previous").textValue(),
                metaNode.get("total_count").intValue(),
                roleTreeNodes);
    }

    public int getLimit() {
        return limit;
    }

    public String getNext() {
        return next;
    }

    public int getOffset() {
        return offset;
    }

    public String getPrevious() {
        return previous;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public List<RoleNodeInfo> getNodes() {
        return nodes;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("limit", limit)
                .add("next", next)
                .add("offset", offset)
                .add("previous", previous)
                .add("totalCount", totalCount)
                .add("nodesCount", nodes.size())
                .toString();
    }
}
