package ru.yandex.infra.auth.idm.service;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

final class IdmGroupRoles extends IdmRoles {
    private final long group;

    IdmGroupRoles(@JsonProperty("group") final long group,
            @JsonProperty("roles") final List<IdmRole> roles) {
        super(roles);
        this.group = group;
    }

    @JsonProperty("group")
    public long getGroup() {
        return group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdmGroupRoles that = (IdmGroupRoles) o;
        return group == that.group;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), group);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("group", group)
                .toString();
    }
}
