package ru.yandex.infra.auth.idm.service;

import java.util.Collections;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

public final class IdmInfoResponse extends IdmServiceResponse {
    private final Optional<IdmRoleNode> rootNode;

    IdmInfoResponse(ResponseCode code,
            String errorMessage,
            Optional<IdmRoleNode> rolesRoot) {
        super(code, errorMessage);
        this.rootNode = rolesRoot;
    }

    @JsonProperty("roles")
    public IdmRoleNode getRootNode() {
        return rootNode.orElseGet(() -> new IdmRoleNode(
                IdmRole.IDM_ROOT_ROLE_NAME,
                IdmRole.IDM_ROOT_ROLE_NAME,
                Collections.emptyMap()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("rootNode", rootNode)
                .toString();
    }
}
