package ru.yandex.infra.auth.idm.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;

public final class IdmLeaf {
    private final IdmName name;
    private final IdmName help;
    private final String uniqueId;

    public IdmLeaf(IdmName name, IdmName help, String uniqueId) {
        this.name = name;
        this.help = help;
        this.uniqueId = uniqueId;
    }

    public IdmLeaf(IdmName name, IdmName help) {
        this(name, help, "");
    }

    public static IdmLeaf configure(Config config) {
        return new IdmLeaf(IdmName.configure(config.getConfig("name")), IdmName.configure(config.getConfig("help")));
    }

    @JsonProperty("name")
    public IdmName getName() {
        return name;
    }

    @JsonProperty("help")
    public IdmName getHelp() {
        return help;
    }

    @JsonProperty("unique_id")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public String getUniqueId() {
        return uniqueId;
    }

    public IdmLeaf withUniqueId(String uniqueId) {
        return new IdmLeaf(name, help, uniqueId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("name", name)
                .add("help", help)
                .add("uniqueId", uniqueId)
                .toString();
    }
}
