package ru.yandex.infra.auth.idm.service;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class IdmMembership {
    private final String login;
    private final Long groupId;

    public IdmMembership(@JsonProperty("login") String login, @JsonProperty("group") Long groupId) {
        this.login = login;
        this.groupId = groupId;
    }

    @JsonProperty("login")
    public String getLogin() {
        return login;
    }

    @JsonProperty("group")
    public Long getGroupId() {
        return groupId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("login", login)
                .add("groupId", groupId)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdmMembership that = (IdmMembership) o;
        return login.equals(that.login) &&
                groupId.equals(that.groupId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(login, groupId);
    }
}

