package ru.yandex.infra.auth.idm.service;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;

public class IdmMembershipsResponse extends IdmServiceResponse {
    private final List<IdmMembership> memberships;

    public IdmMembershipsResponse(ResponseCode code, String errorMessage, List<IdmMembership> memberships) {
        super(code, errorMessage);
        this.memberships = ImmutableList.copyOf(memberships);
    }

    @JsonProperty("memberships")
    public List<IdmMembership> getMemberships() {
        return memberships;
    }
}
