package ru.yandex.infra.auth.idm.service;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;

public final class IdmName {
    public static final IdmName EMPTY_NAME = new IdmName("");
    private final String ruName;
    private final String enName;

    public IdmName(String enName, String ruName) {
        this.ruName = ruName;
        this.enName = enName;
    }

    public IdmName(final String name) {
        ruName = name;
        enName = name;
    }

    public static IdmName fromJsonNode(JsonNode node) {
        return new IdmName(node.get("en").textValue(), node.get("ru").textValue());
    }

    public static IdmName configure(Config config) {
        return new IdmName(config.getString("en"), config.getString("ru"));
    }

    @JsonIgnore
    public boolean isEmpty() {
        return enName.isEmpty() && ruName.isEmpty();
    }

    @JsonProperty("ru")
    public String getRuName() {
        return ruName;
    }

    @JsonProperty("en")
    public String getEnName() {
        return enName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdmName)) {
            return false;
        }
        IdmName that = (IdmName) o;
        return Objects.equals(ruName, that.ruName) &&
                Objects.equals(enName, that.enName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ruName, enName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("ruName", ruName)
                .add("enName", enName)
                .toString();
    }
}
