package ru.yandex.infra.auth.idm.service;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

final class IdmPersonalRoles extends IdmRoles {
    private final String login;

    IdmPersonalRoles(@JsonProperty("login") final String login,
            @JsonProperty("roles") final List<IdmRole> roles) {
        super(roles);
        this.login = login;
    }

    @JsonProperty("login")
    public String getLogin() {
        return login;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("login", login)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdmPersonalRoles that = (IdmPersonalRoles) o;
        return login.equals(that.login);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), login);
    }
}
