package ru.yandex.infra.auth.idm.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

final class IdmRoleNode {
    private final String slug;
    private final String name;
    private final Map<String, Object> values; //Object - String | Leaf | IdmRoles

    IdmRoleNode(String slug, String name, Map<String, Object> values) {
        if (slug == null || slug.isEmpty()) {
            throw new IllegalArgumentException("Slug shouldn't be empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name shouldn't be empty");
        }
        this.slug = slug;
        this.name = name;
        this.values = new HashMap<>(values);
    }

    @JsonProperty("slug")
    public String getSlug() {
        return slug;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("values")
    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(values);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("slug", slug)
                .add("name", name)
                .add("values", values.size())
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdmRoleNode that = (IdmRoleNode) o;
        return slug.equals(that.slug) &&
                name.equals(that.name) &&
                values.equals(that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(slug, name, values);
    }
}
