package ru.yandex.infra.auth.idm.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

class IdmRoles {
    private final List<IdmRole> roles;

    IdmRoles(List<IdmRole> roles) {
        this.roles = roles;
    }

    @JsonProperty("roles")
    public List<Map<String, String>> getRoles() {
        return roles.stream()
                .map(IdmRole::getRoles)
                .collect(Collectors.toUnmodifiableList());
    }

    public void addRole(IdmRole role) {
        roles.add(role);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("roles", roles.size())
                .toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdmRoles)) {
            return false;
        }
        IdmRoles that = (IdmRoles) o;
        return Objects.equals(roles, that.roles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roles);
    }
}
