package ru.yandex.infra.auth.idm.service;

import java.util.Collection;

import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Collections.unmodifiableCollection;


public final class IdmRolesResponse extends IdmServiceResponse {
    private final Collection<IdmPersonalRoles> users;
    private final Collection<IdmGroupRoles> groups;

    IdmRolesResponse(
            ResponseCode code,
            String errorMessage,
            Collection<IdmPersonalRoles> users,
            Collection<IdmGroupRoles> groups) {
        super(code, errorMessage);
        this.users = users;
        this.groups = groups;
    }

    @JsonProperty("users")
    public Collection<IdmPersonalRoles> getUsers() {
        return unmodifiableCollection(users);
    }

    @JsonProperty("groups")
    public Collection<IdmGroupRoles> getGroups() {
        return unmodifiableCollection(groups);
    }
}
