package ru.yandex.infra.auth.idm.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

/**
 * Code 0 means success
 * Another code means, that in fields warning, error or fatal will de description of error
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class IdmServiceResponse {
    private final ResponseCode code;
    private final String warning;
    private final String error;
    private final String fatal;

    public IdmServiceResponse(ResponseCode code, String errorMessage) {
        this.code = code;
        switch (code) {
            case RESPONSE_CODE_SUCCESS:
                this.warning = "";
                this.error = "";
                this.fatal = "";
                break;

            case RESPONSE_CODE_WARNING:
                this.warning = errorMessage;
                this.error = "";
                this.fatal = "";
                break;

            case RESPONSE_CODE_ERROR:
                this.warning = "";
                this.error = errorMessage;
                this.fatal = "";
                break;

            case RESPONSE_CODE_FATAL:
            default:
                this.warning = "";
                this.error = "";
                this.fatal = errorMessage;
        }
    }

    @JsonProperty("code")
    public int getCode() {
        return code.getCode();
    }

    @JsonProperty("warning")
    public String getWarning() {
        return warning;
    }

    @JsonProperty("error")
    public String getError() {
        return error;
    }

    @JsonProperty("fatal")
    public String getFatal() {
        return fatal;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("code", code)
                .add("warning", warning)
                .add("error", error)
                .add("fatal", fatal)
                .toString();
    }

    public enum ResponseCode {
        RESPONSE_CODE_SUCCESS(0),
        RESPONSE_CODE_WARNING(1),
        RESPONSE_CODE_ERROR(2),
        RESPONSE_CODE_FATAL(3);

        int code;

        ResponseCode(int code) {
            this.code = code;
        }

        int getCode() {
            return code;
        }
    }
}
