package ru.yandex.infra.auth.idm.service;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

final class IdmSubRoles {
    private final IdmRoleNode roleNode;
    private final String name;
    private final String uniqueId;

    IdmSubRoles(String name, IdmRoleNode rootNode, String uniqueId) {
        this.roleNode = rootNode;
        this.name = name;
        this.uniqueId = uniqueId;
    }

    @JsonProperty("roles")
    public IdmRoleNode getRoleNode() {
        return roleNode;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("unique_id")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public String getUniqueId() {
        return uniqueId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("name", name)
                .add("roleNode", roleNode)
                .add("uniqueId", uniqueId)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdmSubRoles that = (IdmSubRoles) o;
        return roleNode.equals(that.roleNode) &&
                name.equals(that.name) &&
                uniqueId.equals(that.uniqueId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleNode, name, uniqueId);
    }
}
