package ru.yandex.infra.auth.nanny;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface NannyApi {
    CompletableFuture<NannyServiceInfo> getService(String serviceId);
    CompletableFuture<NannyServiceInfo> getService(String serviceId, int maxAttemptsCount, Duration retryDelay);

    CompletableFuture<List<NannyServiceInfo>> getAllServices(int offset, int count);
    CompletableFuture<List<NannyServiceInfo>> getAllServices(int offset, int count, int maxAttemptsCount, Duration retryDelay);

    CompletableFuture<Set<String>> getAllServices();
    CompletableFuture<Set<String>> getAllServices(int maxAttemptsCount, Duration retryDelay);

    CompletableFuture<NannyServiceInfo> updateService(NannyServiceInfo service);
}
