package ru.yandex.infra.auth.nanny;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;

public class NannyAuthGroup {
    private final Set<String> users;
    private final Set<String> staffGroups;

    public NannyAuthGroup(Set<String> users, Set<String> staffGroups) {
        this.users = users;
        this.staffGroups = staffGroups;
    }

    public static NannyAuthGroup fromJsonNode(JsonNode node) {
        Set<String> logins = new HashSet<>();
        node.get("logins").forEach(n -> logins.add(n.textValue()));

        Set<String> groups = new HashSet<>();
        node.get("groups").forEach(n -> groups.add(n.textValue()));

        return new NannyAuthGroup(logins, groups);
    }

    @JsonProperty("logins")
    public Set<String> getUsers() {
        return users;
    }

    @JsonProperty("groups")
    public Set<String> getStaffGroups() {
        return staffGroups;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || getClass() != other.getClass()) {
            return false;
        }
        NannyAuthGroup that = (NannyAuthGroup) other;
        return Objects.equals(users, that.users) &&
                Objects.equals(staffGroups, that.staffGroups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(users, staffGroups);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("users", users)
                .add("groups", staffGroups)
                .toString();
    }
}
